
# Local Notifications

## <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Apple_logo_black.svg/2000px-Apple_logo_black.svg.png" width=30/> iOS

You can manually trigger local notifications in your JS code, to be posted immediately or in the future.
Triggering local notifications is fully compatible with React Native `PushNotificationsIOS` library.

Example:

```javascript
let localNotification = NotificationsIOS.localNotification({
	body: "Local notificiation!",
	title: "Local Notification Title",
	sound: "chime.aiff",
    silent: false,
	category: "SOME_CATEGORY",
	userInfo: { }
});
```

Notification object contains:

- **`fireDate`**- The date and time when the system should deliver the notification (optinal - default is immidiate dispatch).
- `body`- The message displayed in the notification alert.
- `title`- The title of the notification, displayed in the notifications center.
- `alertAction`- The "action" displayed beneath an actionable notification on the lockscreen (e.g. "Slide to **open**"). Note that Apple no longer shows this in iOS 10.
- `sound`- The sound played when the notification is fired (optional -- will play default sound if unspecified). This must be the filename of a sound included in the application bundle; the sound must be 30 seconds or less and should be encoded with linear PCM or IMA4.
- `silent`- Whether the notification sound should be suppressed (optional).
- `category`- The category of this notification, required for [interactive notifications](#interactive--actionable-notifications-ios-only) (optional).
- `userInfo`- An optional object containing additional notification data.

### Cancel Scheduled Local Notifications

The `NotificationsIOS.localNotification()` and `NotificationsAndroid.localNotification()` methods return unique `notificationId` values, which can be used in order to cancel specific local notifications that were scheduled for delivery on `fireDate` and have not yet been delivered. You can cancel local notification by calling `NotificationsIOS.cancelLocalNotification(notificationId)` or `NotificationsAndroid.cancelLocalNotification(notificationId)`.

Example:

```javascript
let someLocalNotification = NotificationsIOS.localNotification({
	body: "Local notificiation!",
	title: "Local Notification Title",
	sound: "chime.aiff",
	category: "SOME_CATEGORY",
	userInfo: { }
});

NotificationsIOS.cancelLocalNotification(someLocalNotification);
```

To cancel all local notifications (**iOS only!**), use `cancelAllLocalNotifications()`:

```javascript
NotificationsIOS.cancelAllLocalNotifications();
```

#### Cancel Delivered Local Notifications (iOS 10+ only)

To dismiss notifications from the notification center that have already been shown to the user, call `NotificationsIOS.removeDeliveredNotifications([notificationId])`:

```javascript
let someLocalNotification = NotificationsIOS.localNotification({...});

NotificationsIOS.removeDeliveredNotifications([someLocalNotification]);
```

Call `removeAllDeliveredNotifications()` to dismiss all delivered notifications
(note that this will dismiss push notifications in addition to local
notifications).


## <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/a/a0/APK_format_icon.png/768px-APK_format_icon.png" width=30/> Android

Much like on iOS, notifications can be triggered locally. The API to do so is a simplified version of the iOS equivalent that works more natually with the Android perception of push (remote) notifications:

```javascript
NotificationsAndroid.localNotification({
	title: "Local notification",
	body: "This notification was generated by the app!",
	extra: "data"
});
```

Upon notification opening (tapping by the device user), all data fields will be delivered as-is).
