package org.ylhealth.ym.springtest.controller;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.ylhealth.ym.springtest.entity.CrmSystemL1basic;
import org.ylhealth.ym.springtest.repo.CrmSystemL1basicRepo;

@RestController
public class I18NTestController {
  @Inject CrmSystemL1basicRepo dao;


  @GetMapping("/i18n/Test11")
  public CrmSystemL1basic test11() {
    return dao.findOne("01");
  }
  @GetMapping("/i18n/Test12")
  public CrmSystemL1basic test12() {
    return dao.findByGroupCode("01");
  }
  @GetMapping("/i18n/Test13")
  public List<CrmSystemL1basic> test13() {
    return dao.findAll();
  }
  @GetMapping("/i18n/Test21")
  public CrmSystemL1basic test21() {
    LocaleContextHolder.setLocale(Locale.SIMPLIFIED_CHINESE);
    return dao.findOne("01");
  }
  @GetMapping("/i18n/Test22")
  public CrmSystemL1basic test22() {
    LocaleContextHolder.setLocale(Locale.SIMPLIFIED_CHINESE);
    return dao.findByGroupCode("01");
  }
}
