package org.ylhealth.ym.springtest.hibernate;

import org.hibernate.boot.Metadata;
import org.hibernate.cfg.beanvalidation.DuplicationStrategyImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 運用 org.hibernate.integrator.spi.Integrator 處理多國語系基本檔
 * 參考：
 * https://github.com/deathman92/localized
 */
public class I18NInterceptor implements Integrator {
  private Logger logger = LoggerFactory.getLogger(getClass());

  @Override
  public void integrate(
      Metadata metadata,
      SessionFactoryImplementor sessionFactory,
      SessionFactoryServiceRegistry serviceRegistry) {
    logger.debug("integrate...");

    final EventListenerRegistry eventListenerRegistry =
        serviceRegistry.getService(EventListenerRegistry.class);
    eventListenerRegistry.addDuplicationStrategy(DuplicationStrategyImpl.INSTANCE);
    eventListenerRegistry.appendListeners(
        EventType.POST_LOAD, new I18NReadEventListener(sessionFactory));
  }

  @Override
  public void disintegrate(
      SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    logger.debug("disintegrate...");
  }
}
