package org.ylhealth.ym.springtest.hibernate;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface I18NTranslates {
  /**
   *  翻譯表格對應的資料 id 欄位
   *
   * @return
   */
  String id();

  /**
   * 翻譯的表格
   *
   * @return
   */
  String table();

  /**
   * 要翻譯的資料欄位對應
   */
  I18NTranslate[] mapping();
}
