package org.ylhealth.ym.springtest.service;

import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.transaction.Transactional.TxType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.ylhealth.ym.springtest.entity.UserInfo;
import org.ylhealth.ym.springtest.repo.UserInfoRepo;

/**
 * 測試 @Transactional 的使用
 * 在 servcie 中互 call，被 call 的 method ， annotation 是無效的。
 * 觀察 o.s.orm.jpa.JpaTransactionManager 的 log 是不是在 method 中的 log 之前還是之後來辨断
 */
@Service
public class TransactionTestServiceImpl implements TransactionTestService {
  private Logger logger = LoggerFactory.getLogger(getClass());

  @Inject private UserInfoRepo userInfoRepo;

  @Override
  public UserInfo findUserInfo(String id) {
    return userInfoRepo.findOne(id);
  }

  @Override
  public void save(UserInfo u) {
    userInfoRepo.save(u);
  }


  @Override
  @Transactional(value=TxType.REQUIRES_NEW)
  public void testTransaction1() {
    logger.debug("testTransaction1 start");
    userInfoRepo.findOne("aaa");
    logger.debug("testTransaction1 end");
  }

  @Override
  @Transactional(value=TxType.REQUIRES_NEW)
  public void testTransaction2() {
    logger.debug("testTransaction2 start");
    userInfoRepo.findOne("aaa1");
    logger.debug("testTransaction2 end");
  }

  /**
   * service 中互 call, 被 call 的 method annotation 是無效的
   * transaction 會在實際使用到時才產生
   */
  @Override
  public void testTransaction() {
    logger.debug("testTransaction start");
    testTransaction1();
    testTransaction2();
    logger.debug("testTransaction end");
  }
  
  /**
   * 只會產生一個 Transaction
   */
  @Override
  @Transactional(value=TxType.REQUIRED)
  public void testTransaction3() {
    logger.debug("testTransaction3 start");
    testTransaction1();
    testTransaction2();
    logger.debug("testTransaction3 end");
  }
}
