# Hello GL

This minimal example shows the classical "Hello World" of OpenGL 2D drawing, showing a nice 2D gradient where:

- The RED component increases with the X position of the pixel.
- The GREEN component increases with the Y position of the pixel.

> N.B. a GLSL fragment uses a ["functional rendering"](http://greweb.me/2013/11/functional-rendering/)
paradigm, which means you have to implement a `Position => Color` function.

```html
<HelloGL width={256} height={171} />
```

![](1.jpg)

## Implementation

```js
const React = require("react-native");
const GL = require("gl-react-native");

const shaders = GL.Shaders.create({
  helloGL: {
    frag: `
precision highp float;
varying vec2 uv; // This variable vary in all pixel position (normalized from vec2(0.0,0.0) to vec2(1.0,1.0))

void main () { // This function is called FOR EACH PIXEL
  gl_FragColor = vec4(uv.x, uv.y, 0.5, 1.0); // red vary over X, green vary over Y, blue is 50%, alpha is 100%.
}
    `
  }
});

class HelloGL extends React.Component {
  render () {
    const { width, height } = this.props;
    return <GL.View
      shader={shaders.helloGL}
      width={width}
      height={height}
    />;
  }
}
```

A GL component is implemented in 2 parts:

- first, you need to implement a fragment shader in GLSL (OpenGL Shading Language).
Give it to `GL.Shaders.create` and you have a backed object in return (like `StyleSheet.create`).
- second, you can render a `<GL.View>` and pass-in the shader you have defined previously. **Do not forget to give a width and height**.
